# sight 25.1.0

## Enhancement:

### ci

*Add support for point operator in maps.*

## Bug fixes:

### ci

*Update XML hooks to work with auto start.*

*Use singular in root folders names.*

*Coverage comment.*

*Add support for snake_case shader files names.*

*Add support for updater in check_xml hook.*

## New features:

### ci

*Sight-cov tokenization for CI.*

* add token support for gitlab CI calling
* add coverage commentator that will update the coverage reports links directly on the given MR
* add a new minimal python docker image for calling coverage scripts

*A tool to analyse the difference in disk usage between 2 directories.*


# sight 25.0.0

## Bug fixes:

### build

*Bad report generated by code coverage CLI helper.*

This commit addresses several issues and improvements in the algorithm and CLI functionality for generating code coverage reports. Specifically, it fixes the method of identifying the development branch artifact by iterating through all dev branch pipelines and validating their git SHA and coverage job availability.
A `--verbose` option has been added to the CLI for detailed output. Furthermore, the codebase has transitioned from using `os.path` to `pathlib.Path`, simplifying path manipulations.
Additionally, it updates the `python-gitlab` library from version 4.10.0 to 5.3.1 in the requirements.

### ci

*An unexpected encoding exception in code coverage CLI helper.*

*Do not reflow comment with newer versions of uncrustify.*

## Enhancement:

### build

*Improve Windows experience.*

* Launching sheldon from PowerShell or cmd is now possible by executing command line sheldon or sheldon.bat
* Launching sheldon --help no longer produce an error
* Adding howto install Chocolatey and UniGetUI in README

### ci

*Fixed issues with properties parsing.*

*Add support for properties in check_xml hook.*

## New features:

### ci

*Add sight-cov utility to download coverage reports.*

A new CLI is available, `sight-cov.py`. Here is the synopsis:

```shell
usage: sight-cov.py [-h] [-d] [--html] repository merge-request

Download the code coverage report from the latest pipeline of a merge-request.

positional arguments:
  repository     Name of the repository: "sight", "night", or any private repository.
  merge-request  Identifier of the merge-request, same as the one present in its URL.

options:
  -h, --help     show this help message and exit
  -d, --diff     Compute the diff of the coverage with the dev branch.
  --html         Html output instead of text.
```

Here is the output of the utility:

```shell
# ~/dev/sight/sight-git/sight-cov.py -d sight 470 --html
Downloading merge-request !470 artifacts for project sight...

Coverage report is available at:
file:///home/user/dev/sight/.coverage/sight%21470%23301939/coverage/index.html

Downloading dev branch artifacts for project sight

Diff coverage report is available at:
file:///home/user/dev/sight/.coverage/report.html
```


# sight 24.1.0

## Bug fixes:

### ci

*Sheldon enters infinite loop when Licence.txt is absent.*

Sheldon looks for a Licence.txt file in the source tree. If there is none, an error message is now displayed and the hook fails.

## New features:

### build

*Prettier xml formatter integration.*

Take a look at https://github.com/prettier/plugin-xml for further explanation.


# sight 24.0.0

## Bug fixes:

### ci

*Adapt includes sort with new config.hpp syntax.*

*Adapt registry parsing to snake case configs.*

*Add an exception for scene3d_qt to compute xml dependencies.*

*Add new service exception in check_xml_dependencies hook.*

*Fix check_xml_dependencies hook with new snake_case syntax.*

## Enhancement:

### ci

*Allow to ignore certain preprocessor define directive when attempting to compile shaders.*


# sight 23.1.0

## Bug fixes:

### ci

*Update clang-tidy version.*

## Enhancement:

### ci

*Show glslangValidator command & output.*


# sight 23.0.0

## New features:

### ci

*Speed-up glslang_validator hook by parallelizing execution.*

*Add support for CUDA source files.*


# sight 22.1.0

## Bug fixes:

### ci

*Generated code can be bigger than default limit.*

### doc

*Update README.md to reflect changes on static analysis tools.*


# sight 22.0.0

## Enhancement:

### ci

*Remove CppCheck from the default hooks list.*

*Unhardcode some of CppCheck commandline options.*

*Add warnings as errors for CppCheck.*

*Enable CppCheck again.*

## Bug fixes:

### ci

*Add missing cmake option when regenerating compile_command.json.*

*Add new C++ 20 headers to help with sorting.*

*Fix clang-tidy error code ignored when using html report mode.*

*Fix error messages being displayed as warnings.*

Because of a regression, error messages were displayed as warnings. This is now fixed and error messages are now well displayed as errors.

*Also check renamed files.*

*Ignore flake8 import place error.*

## New features:

### ci

*Add a new option to choose the hooks to be run.*


# sight 21.1.0

## Bug fixes:

### ci

*Import of common.py in gen_changelog.*

*Add an option to cspell to ignore inexistent files.*

*Cspell discovery on Windows.*

*Glsl file processing & script headers.*

*Sort of includes with targets using multi lines sight_add_target.*

*Include sort broken in child repositories.*

Now we consider that we only prioritize the libraries of the current repository in the includes sort. Thus, a child project will consider sight includes like any other 3rd part library. This simplifies a lot the process. The unit test has been enriched to take that into account.

We also changed the way the root of the repository is searched. We used to rely on `git-rev-parse`, but this is a bit annoying for unit-testing. On top of that, when using `sheldon -i`, we use to fail to sort the includes if we do not run the command **inside** the repository. The new method proposes to look recursively and backward a .sight file in the file tree.

*Sheldon won't work with xml files defined in the same module.*

### test

*Use file inclusion for cspell and add unit test.*

## Enhancement:

### ci

*Update sheldon to make cspell error fatal.*

*Improve spell checking.*

* check all files at once
* improve sight-dict.txt by adding new words
* add exclusion list for files that we doesn't handle yet (cmake, xml, ...)

*Add cmake formater and linter.*

Use [cmake-format](https://cmake-format.readthedocs.io/en/latest/cmake-format.html) to format and check cmake files and [cmake-lint](https://cmake-format.readthedocs.io/en/latest/cmake-lint.html) as linter.

## New features:

### ci

*Add cspell hook.*

- Add cspell.py script to apply cspell on updated files
- Allow to use dictionaries from the sheldon repository and
  the checked repository root, located in the .cspell folder

*Add a lint job.*

A lint phase was added, which runs flake8.

Two exceptions were made:
- Error E731 is skipped because I just don't like replacing a one-liner with 6 lines.
- Warning W503 is skipped because one has to choose between W504 or W503. Pick your poison... :smile_cat:

A fix was also made in the licence year replacement. When having a single old date, sheldon just replaced the year as it is, whereas it was supposed to create a range with the old date and the new date, i.e. `2009` should give `2009-2021` and not `2021`. A unit test has been added to avoid future regressions.


# sight 21.0.0

## Refactor:

### core

*Update glslang_validator to support includes in Ogre.*

## Enhancement:

### core

*Do not remove unneeded switch case scope brace.*

*Modify many hooks to comply with the sight 21.0 layout.*

## Bug fixes:

### ci

*Uncrustify comment alignment.*

*Add space between members variable and initializers.*

### core

*Reverse the test in check_xml_dependencies for service types.*

Targets without a category (io, viz, ui, etc...) are now handled properly.

*Header includes are not properly sorted.*

To guess the library name from the path, instead of looking for `src` or `include`, now we just look backwards for a `CMakeLists.txt`.

*False positive in check_xml_dependencies.*

*Adapt check_xml_dependencies to the new build system.*

### test

*Adapt tests data to sight 21.0.*

## New features:

### ci

*Update uncrustify and indent rules.*

### core

*Allow to exclude a directory from checking.*

Allows to specify a .sheldonignore files with similar syntax as .gitignore to filter files to be sheldonized. It could be useful for files that we want to keep as is, because they belong to external sources (for example `minizip` sources).

> adding a leading '/' means *absolute* path. Like in regular `.gitignore`, it allow to match only things at *root* level.
> wildcard (*?...) are supported

### doc

*Update uncrustify version to 0.72.*


